/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.sets.shadow;

import dev.xkmc.curseofpandora.content.complex.BaseTickingToken;
import dev.xkmc.curseofpandora.content.complex.IAttackListenerToken;
import dev.xkmc.curseofpandora.content.complex.ITokenProviderItem;
import dev.xkmc.curseofpandora.content.sets.shadow.VoidOverflow;
import dev.xkmc.curseofpandora.event.ClientSpellText;
import dev.xkmc.curseofpandora.event.ItemEffectHandlers;
import dev.xkmc.curseofpandora.init.data.CoPConfig;
import dev.xkmc.curseofpandora.init.data.CoPDamageTypeGen;
import dev.xkmc.curseofpandora.init.data.CoPLangData;
import dev.xkmc.curseofpandora.init.registrate.CoPAttrs;
import dev.xkmc.curseofpandora.init.registrate.CoPEffects;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import org.jetbrains.annotations.Nullable;

public class ShadowConsolidation
extends ITokenProviderItem<Data> {
    public static int getIndexReq() {
        return (Integer)CoPConfig.COMMON.shadow.shadowConsolidationRealityIndex.get();
    }

    public static double getRange() {
        return (Double)CoPConfig.COMMON.shadow.shadowConsolidationRange.get();
    }

    public static double getFactor() {
        return (Double)CoPConfig.COMMON.shadow.shadowConsolidationFactor.get();
    }

    public static int getDelay() {
        return (Integer)CoPConfig.COMMON.shadow.shadowConsolidationDelay.get();
    }

    public static int getCoolDown() {
        return (Integer)CoPConfig.COMMON.shadow.shadowConsolidationCoolDown.get();
    }

    public ShadowConsolidation(Item.Properties properties) {
        super(properties, Data::new);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        boolean pass = ClientSpellText.getReality(level) >= ShadowConsolidation.getIndexReq();
        list.add((Component)CoPLangData.IDS.REALITY_INDEX.get(ShadowConsolidation.getIndexReq()).m_130940_(pass ? ChatFormatting.YELLOW : ChatFormatting.GRAY));
        list.add((Component)CoPLangData.Shadow.CONSOLIDATION.get(Math.round(ShadowConsolidation.getRange()), Math.round(ShadowConsolidation.getFactor() * 100.0), Math.round((double)ShadowConsolidation.getDelay() / 20.0), Math.round((double)ShadowConsolidation.getCoolDown() / 20.0)).m_130940_(pass ? ChatFormatting.DARK_AQUA : ChatFormatting.DARK_GRAY));
    }

    @Override
    public void tick(Player player) {
        if (player.m_21133_((Attribute)CoPAttrs.REALITY.get()) >= (double)ShadowConsolidation.getIndexReq()) {
            super.tick(player);
        }
    }

    private record Entry(Vec3 pos, float damage) {
    }

    private static class Frame {
        private final List<Entry> list = new ArrayList<Entry>();
        private int tick = ShadowConsolidation.getDelay();

        private Frame() {
        }

        public void add(LivingEntity target, float damage) {
            ItemEffectHandlers.SHADOW_CONSOLIDATION.trigger(target);
            this.list.add(new Entry(target.m_20182_(), damage));
        }

        public void execute(Player player) {
            Level level = player.m_9236_();
            double r = ShadowConsolidation.getRange();
            AABB aabb = null;
            for (Entry e2 : this.list) {
                AABB self = AABB.m_165882_((Vec3)e2.pos(), (double)(r * 2.0), (double)(r * 2.0), (double)(r * 2.0));
                if (aabb == null) {
                    aabb = self;
                    continue;
                }
                aabb = aabb.m_82367_(self);
            }
            if (aabb == null) {
                return;
            }
            double r2 = r * r;
            ResourceKey<DamageType> type = VoidOverflow.check(player) ? CoPDamageTypeGen.VOID_CURSE : CoPDamageTypeGen.SHADOW_CURSE;
            Holder<DamageType> source = CoPDamageTypeGen.forKey(level, type);
            for (Mob e3 : level.m_142425_(EntityTypeTest.m_156916_(Mob.class), aabb, e -> e instanceof Enemy)) {
                float damage = 0.0f;
                for (Entry pos : this.list) {
                    if (!(e3.m_20238_(pos.pos) <= r2)) continue;
                    damage += pos.damage;
                }
                e3.m_6469_(new DamageSource(source, (Entity)player), (float)((double)damage * ShadowConsolidation.getFactor()));
            }
        }
    }

    @SerialClass
    public static class Data
    extends BaseTickingToken
    implements IAttackListenerToken {
        private Frame current;
        @SerialClass.SerialField
        private int cooldown = 0;

        @Override
        protected void removeImpl(Player player) {
        }

        @Override
        protected void tickImpl(Player player) {
            if (this.current != null) {
                --this.current.tick;
                if (this.current.tick <= 0) {
                    this.current.execute(player);
                    this.current = null;
                }
            }
            if (this.cooldown > 0) {
                --this.cooldown;
            }
        }

        @Override
        public void onPlayerDamageTargetFinal(Player player, AttackCache cache) {
            LivingDamageEvent event = cache.getLivingDamageEvent();
            assert (event != null);
            if (event.getSource().m_269533_(CoPDamageTypeGen.SHADOW)) {
                return;
            }
            if (!cache.getAttackTarget().m_21023_((MobEffect)CoPEffects.SHADOW.get())) {
                return;
            }
            if (this.current == null) {
                if (this.cooldown > 0) {
                    return;
                }
                this.current = new Frame();
                this.cooldown = ShadowConsolidation.getCoolDown();
            }
            this.current.add(cache.getAttackTarget(), cache.getDamageDealt());
        }
    }
}

